 ; Ŀ
 ;   Boch - chgtext for Bom hex tags.                                      
 ;   Copyright 1995, 2005 by Rocket Software Ltd.                          
 ;   The original and replacement strings are incremented and become       
 ;   the defaults for the next cycle.                                      
 ;   Also contains Ftag: draw temporary lines from bom number text to      
 ;   matching blocks.                                                      
 ;   Why does no-one stand in a river and skip rocks onto the bank?        
 ; 

 ; Ŀ
 ;   Ftag.                                                                 
 ; 
 (DEFUN C:FTAG (/ ss strlis ssb bomlis num sub str pa ovn)
 ; Ŀ
 ;   Get a selection set of text and attdefs.                              
 ; 
  (write-line "Select Bom number text: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
 ; Ŀ
 ;   Make a list of lists: each text or attdef string and ename.           
 ; 
  (setq strlis (stnam ss))
 ; Ŀ
 ;   Get an ss of Bomtag inserts.                                          
 ; 
  (setq ssb (ssget "x" '((2 . "bomtag"))))
 ; Ŀ
 ;   Make a list of lists: each Bomtag insert number (string) and ename.   
 ; 
  (setq bomlis (stnam ssb))
 ; Ŀ
 ;   For each string in Strlis, grdraw a line to each matching bom tag.    
 ; 
  (setq num 0)
  (while (setq sub (nth num strlis))
         (setq num (1+ num))
         (setq str (car sub))
         (setq pa (cdr (assoc 10 (entget (cadr sub)))))
         (setq ovn 0)
         (while (setq sub (nth ovn bomlis))
                (setq ovn (1+ ovn))
                (if (= (car sub) str)
                    (grdraw pa (cdr (assoc 10 (entget (cadr sub)))) num))))
 (princ))
 ; Ŀ
 ;   Ftag end.                                                             
 ; 

 ; Ŀ
 ;   Stnam - extract a list ((strings ename) ...) from text and inserts.   
 ;   Arguments: Ss, an ss.                                                 
 ;   Calls nothing, returns a list.                                        
 ; 
 (DEFUN STNAM (ss / num enam typ strlis)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq typ (cdr (assoc 0 (entget enam))))
         (cond ((= typ "INSERT")
                (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                              (setq enam (entnext enam)))))))
                       (setq strlis (cons (list (cdr (assoc 1 entt)) enam)
                                                                     strlis))))
               ((= typ "TEXT")
                (setq strlis (append strlis (list (list 
                                        (cdr (assoc 1 (entget enam))) enam)))))
               ((= typ "ATTDEF")
                (setq strlis (append strlis (list (list 
                                      (cdr (assoc 2 (entget enam))) enam)))))))
 strlis)
 ; Ŀ
 ;   Stnam end.                                                            
 ; 

 ; Ŀ
 ;   Boch.                                                                 
 ; 
 (DEFUN C:BOCH (/ rad nump cont dd glist ss num chags enam entt txt pa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq rad (/ (getvar "viewsize") 45))
 ; Ŀ
 ;   Get an existing number strings.                                       
 ; 
  (if (= (type bomnum) 'STR)
      (progn
           (setq nump (getstring t (strcat "\nExisting number <" bomnum ">:")))
           (if (/= nump "") (setq bomnum nump)))
      (progn
           (setq cont t)
           (while cont
                 (setq bomnum (getstring t "\nExisting number:"))
                 (if (= bomnum "")
                 (princ "Can't search for nothing.")
                 (setq cont nil)))))
 ; Ŀ
 ;   Get a replacement number string.                                      
 ; 
  (if (= (type bomnew) 'STR)
      (progn
           (setq newp (getstring t (strcat "\nReplacement number <" bomnew ">:")))
           (if (/= newp "") (setq bomnew newp)))
      (progn
           (setq cont t)
           (while cont
                 (setq bomnew (getstring t "\nReplacement number:"))
                 (if (= bomnew "")
                 (princ "Can't search for nothing.")
                 (setq cont nil)))))
 ; Ŀ
 ;   If the replacement string was a space then empty it.                  
 ; 
  (if (= bomnew " ") (setq bomnew ""))
 ; Ŀ
 ;   Get entities to change.                                               
 ; 
  (setq ss (ssget "x" '((-4 . "<and") (0 . "insert") (2 . "bomtag")
                        (-4 . "and>"))))
 ; Ŀ
 ;   Change them.                                                          
 ; 
  (setq num 0)
  (setq chags 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget (entnext enam)))
         (setq txt (cdr (assoc 1 entt)))
         (if (= txt bomnum)
             (progn
                  (setq chags (1+ chags))
                  (setq pa (cdr (assoc 10 entt)))
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7)
                  (entmod (subst (cons 1 bomnew) (assoc 1 entt) entt))
                  (entupd enam))))
 ; Ŀ
 ;   Increment both numbers, if they are numbers.                          
 ; 
  (if (= (type (read bomnum)) 'INT)
      (setq bomnum (itoa (1+ (read bomnum)))))
  (if (= (type (read bomnew)) 'INT)
      (setq bomnew (itoa (1+ (read bomnew)))))
 ; Ŀ
 ;   Explain, end.                                                         
 ; 
  (prompt (strcat "Bom tags changed: " (itoa chags)))
  (command "undo" "end")
 (princ))